/*
 * Decompiled with CFR 0.152.
 */
package PieMonsterEater.Engine.Core;

import PieMonsterEater.Engine.Audio.MusicPlayer;
import PieMonsterEater.Engine.Core.Window;
import PieMonsterEater.Engine.Entities.Astroid;
import PieMonsterEater.Engine.Entities.Spawner;
import PieMonsterEater.Engine.EntityCore.Handler;
import PieMonsterEater.Engine.EntityCore.ID;
import PieMonsterEater.Engine.Menus.InfoMenu;
import PieMonsterEater.Engine.Menus.MainMenu;
import PieMonsterEater.Engine.Menus.StateID;
import PieMonsterEater.Engine.Player.Bullet;
import PieMonsterEater.Engine.Player.Camera;
import PieMonsterEater.Engine.Player.KeyInput;
import PieMonsterEater.Engine.Player.MouseInput;
import PieMonsterEater.Engine.Player.Player;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferStrategy;

public class Game
extends Canvas
implements Runnable {
    public static final int WIDTH = 640;
    public static final int HEIGHT = 477;
    public static StateID state = StateID.MainMenu;
    public boolean running = false;
    private Thread thread;
    private Handler handler;
    private MusicPlayer mp;
    private Spawner spawner;
    private MainMenu mainM = new MainMenu();
    private InfoMenu iMenu = new InfoMenu();
    public static Rectangle rect = new Rectangle(200, 250, 40, 40);
    Camera camera = new Camera(0, 0);

    public Game() {
        new Window("SpaceGame", 640, 477, this);
        this.handler = new Handler();
        this.handler.addObj(new Player(100, 350, this.handler));
        this.handler.addObj(new Astroid(250, 250, this.handler));
        this.handler.addObj(new Bullet(100, 100, this.handler));
        this.spawner = new Spawner(this.handler);
        this.addKeyListener(new KeyInput(this.handler));
        this.addMouseListener(new MouseInput(this.handler));
    }

    public synchronized void start() {
        this.thread = new Thread(this);
        this.thread.start();
        this.running = true;
    }

    public synchronized void stop() {
        this.thread = new Thread(this);
        try {
            this.thread.join();
            this.running = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.requestFocus();
        long lastTime = System.nanoTime();
        double amountOfTicks = 60.0;
        double ns = 1.0E9 / amountOfTicks;
        double delta = 0.0;
        long timer = System.currentTimeMillis();
        int frames = 0;
        while (this.running) {
            long now = System.nanoTime();
            delta += (double)(now - lastTime) / ns;
            lastTime = now;
            while (delta >= 1.0) {
                this.tick();
                delta -= 1.0;
            }
            if (this.running) {
                this.render();
            }
            ++frames;
            if (System.currentTimeMillis() - timer <= 1000L) continue;
            timer += 1000L;
            System.out.println("FPS:" + frames);
            frames = 0;
        }
        this.stop();
    }

    public void tick() {
        if (state == StateID.Play) {
            this.handler.tick();
            this.spawner.tick();
            int i = 0;
            while (i < this.handler.object.size()) {
                if (this.handler.object.get(i).getID() == ID.Player) {
                    this.camera.tick(this.handler.object.get(i));
                }
                ++i;
            }
        }
    }

    public void render() {
        BufferStrategy bs = this.getBufferStrategy();
        if (bs == null) {
            this.createBufferStrategy(3);
            return;
        }
        Font fnt = new Font("ComicSans", 1, 50);
        Font fnt1 = new Font("ComicSans", 0, 20);
        Graphics g = bs.getDrawGraphics();
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, 640, 477);
        if (state == StateID.MainMenu) {
            this.mainM.render(g);
        }
        if (state == StateID.InfoMenu) {
            this.iMenu.render(g);
        }
        if (state == StateID.Play) {
            this.handler.render(g);
            if (Player.dead) {
                g.setColor(Color.RED);
                g.setFont(fnt);
                g.drawString("YOU DIED!", 200, 150);
                g.setFont(fnt1);
                g.setColor(Color.WHITE);
                g.drawString("FinalScore: " + Player.score, 200, 200);
                g.setColor(Color.ORANGE);
                g.drawString("Retry", Game.rect.x, Game.rect.y + 20);
                g.drawRect(Game.rect.x, Game.rect.y, 40, 40);
            }
        }
        g.dispose();
        bs.show();
    }
}

