/*
 * Decompiled with CFR 0.152.
 */
package PieMonsterEater.Engine.Entities;

import PieMonsterEater.Engine.EntityCore.GameObject;
import PieMonsterEater.Engine.EntityCore.Handler;
import PieMonsterEater.Engine.EntityCore.ID;
import PieMonsterEater.Engine.Player.Player;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class Astroid
extends GameObject {
    private Handler handler;
    private int deathDelay = 50;
    private int timer = 300;
    private boolean dead = false;
    BufferedImage[] spin = new BufferedImage[4];
    BufferedImage[] death = new BufferedImage[2];

    public Astroid(int x, int y, Handler handler) {
        super(x, y, handler);
        this.handler = handler;
        this.setSpriteSheet("res/SpriteSheet.png");
        this.setID(ID.Asteroid);
        this.spin[0] = this.ss.grabSprite(96, 0, 32, 32);
        this.spin[1] = this.ss.grabSprite(128, 0, 32, 32);
        this.spin[2] = this.ss.grabSprite(160, 0, 32, 32);
        this.spin[3] = this.ss.grabSprite(192, 0, 32, 32);
        this.death[0] = this.ss.grabSprite(0, 32, 32, 32);
        this.death[1] = this.ss.grabSprite(32, 32, 32, 32);
        this.setAnimation(this.spin, 3);
    }

    @Override
    public void tick() {
        if (!this.dead) {
            this.y += 6;
            this.collision();
        }
        if (this.dead) {
            --this.deathDelay;
        }
        if (this.deathDelay <= 0) {
            this.handler.removeObj(this);
        }
        this.ani.tick();
        this.setSpr(this.ani.getImage());
        --this.timer;
        if (this.timer <= 0) {
            this.handler.removeObj(this);
        }
    }

    @Override
    public void render(Graphics g) {
        g.drawImage(this.sprite, this.x, this.y, 64, 64, null);
    }

    public void collision() {
        int i = 0;
        while (i < this.handler.object.size()) {
            GameObject tempObject = this.handler.object.get(i);
            if (tempObject.getID() == ID.Bullet && this.getBounds().intersects(tempObject.getBounds())) {
                this.dead = true;
                this.setAnimation(this.death, 4);
                this.playSound("res/Explosion.wav");
                ++Player.score;
            }
            ++i;
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x + 25, this.y + 10, 32, 32);
    }
}

