/*
 * Decompiled with CFR 0.152.
 */
package PieMonsterEater.Engine.EntityCore;

import PieMonsterEater.Engine.Audio.SoundEffect;
import PieMonsterEater.Engine.EntityCore.Handler;
import PieMonsterEater.Engine.EntityCore.ID;
import PieMonsterEater.Engine.Visuals.Animator;
import PieMonsterEater.Engine.Visuals.BufferedImageLoader;
import PieMonsterEater.Engine.Visuals.SpriteSheet;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;

public abstract class GameObject {
    protected int x;
    protected int y;
    protected int velX;
    protected int velY;
    protected int currentAnimation;
    protected ID id;
    protected BufferedImage sprite;
    protected BufferedImage spriteSheet;
    protected SpriteSheet ss;
    protected Animator ani;
    protected SoundEffect se;
    protected boolean animating = false;

    public abstract void tick();

    public abstract void render(Graphics var1);

    public abstract Rectangle getBounds();

    public GameObject(int x, int y, Handler handler) {
        this.x = x;
        this.y = y;
        this.ani = new Animator();
        this.se = new SoundEffect();
    }

    public void setSpriteSheet(String spriteLocal) {
        BufferedImageLoader loader = new BufferedImageLoader();
        try {
            this.spriteSheet = loader.loadImage(spriteLocal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.ss = new SpriteSheet(this.spriteSheet);
    }

    public void setAnimation(BufferedImage[] images, int delay) {
        this.ani.setFrames(images);
        this.ani.setDelay(delay);
    }

    public void playSound(String name) {
        this.se.playSound(name);
    }

    public void setSprite(int pixelX, int pixelY, int pixelWidth, int pixelHeight) {
        this.sprite = this.ss.grabSprite(pixelX, pixelY, pixelWidth, pixelHeight);
    }

    public void animate() {
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getVelX() {
        return this.velX;
    }

    public void setVelX(int velX) {
        this.velX = velX;
    }

    public int getVelY() {
        return this.velY;
    }

    public void setVelY(int velY) {
        this.velY = velY;
    }

    public ID getID() {
        return this.id;
    }

    public void setID(ID id) {
        this.id = id;
    }

    public void setSpr(BufferedImage sprite) {
        this.sprite = sprite;
    }
}

