/*
 * Decompiled with CFR 0.152.
 */
package PieMonsterEater.Engine.Player;

import PieMonsterEater.Engine.EntityCore.GameObject;
import PieMonsterEater.Engine.EntityCore.Handler;
import PieMonsterEater.Engine.EntityCore.ID;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class Bullet
extends GameObject {
    private Handler handler;
    BufferedImage[] shoot = new BufferedImage[2];
    private int timer = 50;

    public Bullet(int x, int y, Handler handler) {
        super(x, y, handler);
        this.handler = handler;
        this.setSpriteSheet("res/SpriteSheet.png");
        this.shoot[0] = this.ss.grabSprite(32, 0, 33, 32);
        this.shoot[1] = this.ss.grabSprite(64, 0, 35, 31);
        this.setID(ID.Bullet);
        this.setAnimation(this.shoot, 2);
    }

    @Override
    public void tick() {
        this.x += this.velX;
        this.y += this.velY;
        --this.velY;
        --this.timer;
        if (this.timer <= 0) {
            this.handler.removeObj(this);
        }
        this.ani.tick();
        this.setSpr(this.ani.getImage());
    }

    @Override
    public void render(Graphics g) {
        g.drawImage(this.sprite, this.x, this.y, 60, 60, null);
    }

    public void collision() {
        int i = 0;
        while (i < this.handler.object.size()) {
            GameObject tempObject = this.handler.object.get(i);
            if (tempObject.getID() == ID.Asteroid && this.getBounds().intersects(tempObject.getBounds())) {
                this.handler.removeObj(this);
            }
            ++i;
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x + 20, this.y + 15, 32, 32);
    }
}

