/*
 * Decompiled with CFR 0.152.
 */
package PieMonsterEater.Engine.Player;

import PieMonsterEater.Engine.Audio.MusicPlayer;
import PieMonsterEater.Engine.EntityCore.GameObject;
import PieMonsterEater.Engine.EntityCore.Handler;
import PieMonsterEater.Engine.EntityCore.ID;
import PieMonsterEater.Engine.Player.Bullet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class Player
extends GameObject {
    private Handler handler;
    public static int score = 0;
    public static boolean dead = false;
    public static boolean songStart = false;
    private int deathCounter = 50;
    private MusicPlayer mp = new MusicPlayer();
    BufferedImage[] death = new BufferedImage[2];
    private int timer = 20;
    private boolean justShot = false;

    public Player(int x, int y, Handler handler) {
        super(x, y, handler);
        this.handler = handler;
        this.setID(ID.Player);
        this.setSpriteSheet("res/SpriteSheet.png");
        this.setSprite(0, 0, 32, 32);
        if (!songStart) {
            this.mp.playSong("res/Song.wav");
            songStart = true;
        }
        this.death[0] = this.ss.grabSprite(0, 32, 32, 32);
        this.death[1] = this.ss.grabSprite(32, 32, 32, 32);
    }

    @Override
    public void tick() {
        if (!dead) {
            this.x += this.velX;
            this.x = this.clamp(this.x, -20, 580);
            this.collision();
        } else {
            dead = true;
            if (true) {
                --this.deathCounter;
                this.ani.tick();
                this.setSpr(this.ani.getImage());
            }
        }
        if (this.justShot) {
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 20;
                this.justShot = false;
            }
        }
        if (this.deathCounter <= 0) {
            this.handler.removeObj(this);
        }
    }

    @Override
    public void render(Graphics g) {
        g.setColor(Color.WHITE);
        g.drawImage(this.sprite, this.x, this.y, 80, 80, null);
        g.drawString("Score: " + score, 550, 25);
    }

    public void shoot() {
        if (!this.justShot) {
            this.playSound("res/Shoot.wav");
            this.handler.addObj(new Bullet(this.x + 5, this.y - 10, this.handler));
            this.justShot = true;
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x + 20, this.y, 32, 60);
    }

    public void collision() {
        int i = 0;
        while (i < this.handler.object.size()) {
            GameObject tempObject = this.handler.object.get(i);
            if (tempObject.getID() == ID.Asteroid && this.getBounds().intersects(tempObject.getBounds())) {
                dead = true;
                this.setAnimation(this.death, 4);
                this.playSound("res/Explosion.wav");
            }
            ++i;
        }
    }

    public int clamp(int var, int min, int max) {
        if (var >= max) {
            var = max;
            return var;
        }
        if (var <= min) {
            var = min;
            return var;
        }
        return var;
    }
}

